<?php
/**
 * Plugin Name: Backlink Generator
 * Description: Generate backlinks in real-time with progress bar. Use shortcode [backlink_generator]
 * Version: 1.0
 * Author: BKThemes
 */

add_shortcode('backlink_generator', 'backlink_checker_shortcode');

function backlink_checker_shortcode() {
	ob_start(); ?>
	<style>
		#progress-container { border-radius: 5px; height: 25px; margin: 20px 0; overflow: hidden; display: none; box-sizing: content-box; height: 20px; position: relative; margin: 60px 0 20px 0; background: #555; border-radius: 25px; padding: 10px; box-shadow: inset 0 -1px 1px rgba(255, 255, 255, 0.3); }
		#progress-bar { height: 100%; width: 0%; text-align: center; color: #fff; line-height: 25px; transition: width 0.3s; display: block; border-top-right-radius: 8px; border-bottom-right-radius: 8px; border-top-left-radius: 20px; border-bottom-left-radius: 20px;  background-color: rgb(43, 194, 83);  background-image: linear-gradient( center bottom, rgb(43, 194, 83) 37%, rgb(84, 240, 84) 69% );  box-shadow: inset 0 2px 9px rgba(255, 255, 255, 0.3), inset 0 -2px 6px rgba(0, 0, 0, 0.4);  position: relative;  overflow: hidden; }
		#results { font-family: monospace; white-space: pre-wrap; margin-top: 20px; }
	    #messageContainer {  animation: fadeIn 1s forwards; animation-delay: 2s; }
        @keyframes fadeIn {
          from {
            opacity: 0; /* Start at opacity 0 */
          }
          to {
            opacity: 1; /* End at opacity 1 (fully visible) */
          }
        }
		input[type="text"] {  min-width:25%;  height: 30px; }
		.button-primary {  padding: 5px 20px;  background: #3644af;  color: #fff;  border-radius: 5px;  font-family: 'Russo One',Helvetica,Arial,Lucida,sans-serif; }
	    .result { font-weight: 700;  font-size: large; }
	    
	    .Successfully { color: green; }
	    .Failed { color: red; }
	</style>
	<form id="backlinkForm">
		<input type="text" id="domain" placeholder="Enter domain (https://example.com)" required />
		<button class="button-primary" type="submit">Generate Backlinks</button>
	</form>

	<div id="progress-container"><div id="progress-bar">0%</div></div>
	<div id="results"></div>

	<script>
		document.getElementById("backlinkForm").addEventListener("submit", function(e) {
			e.preventDefault();

			const domain = document.getElementById("domain").value;
			const resultsDiv = document.getElementById("results");
			const progressBar = document.getElementById("progress-bar");
			const progressContainer = document.getElementById("progress-container");

			resultsDiv.innerHTML = "";
			progressBar.style.width = "0%";
			progressBar.textContent = "0%";
			progressContainer.style.display = "block";

			const eventSource = new EventSource("<?php echo plugin_dir_url(__FILE__); ?>stream.php?domain=" + encodeURIComponent(domain));

			let count = 0;
			let total = 0;

			eventSource.onmessage = function(event) {
				const data = JSON.parse(event.data);
				if (data.type === "init") {
					total = data.total;
				} else if (data.type === "line") {
					count++;
					resultsDiv.innerHTML += data.line + "<br>";
					const percent = Math.round((count / total) * 100);
					progressBar.style.width = percent + "%";
					progressBar.textContent = percent + "%";
				} else if (data.type === "done") {
					eventSource.close();
					progressBar.style.backgroundColor = "#2196f3";
					progressBar.textContent = "Done";
				}
			};
		});
	</script>
	<?php return ob_get_clean();
}
